/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.factories.ILocalResearchFactory;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.research.LocalResearch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class LocalResearchFactory
implements ILocalResearchFactory {
    @Override
    @NotNull
    public TypeToken<LocalResearch> getFactoryOutputType() {
        return TypeToken.of(LocalResearch.class);
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public ILocalResearch getNewInstance(ResourceLocation id, ResourceLocation branch, int depth) {
        return new LocalResearch(id, branch, depth);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull ILocalResearch research) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("state", research.getState().ordinal());
        compound.m_128359_("id", research.getId().toString());
        compound.m_128359_("branch", research.getBranch().toString());
        compound.m_128405_("progress", research.getProgress());
        compound.m_128405_("depth", research.getDepth());
        return compound;
    }

    @Override
    @NotNull
    public ILocalResearch deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        int state = nbt.m_128451_("state");
        ResourceLocation id = new ResourceLocation(nbt.m_128461_("id"));
        ResourceLocation branch = new ResourceLocation(nbt.m_128461_("branch"));
        int depth = nbt.m_128451_("depth");
        int progress = nbt.m_128451_("progress");
        ILocalResearch research = this.getNewInstance(id, branch, depth);
        research.setState(ResearchState.values()[state]);
        research.setProgress(progress);
        return research;
    }

    @Override
    public void serialize(IFactoryController controller, ILocalResearch input, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(input.getState().ordinal());
        packetBuffer.m_130070_(input.getId().toString());
        packetBuffer.m_130085_(input.getBranch());
        packetBuffer.writeInt(input.getProgress());
        packetBuffer.writeInt(input.getDepth());
    }

    @Override
    public ILocalResearch deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        int state = buffer.readInt();
        ResourceLocation id = buffer.m_130281_();
        ResourceLocation branch = buffer.m_130281_();
        int progress = buffer.readInt();
        int depth = buffer.readInt();
        ILocalResearch research = this.getNewInstance(id, branch, depth);
        research.setState(ResearchState.values()[state]);
        research.setProgress(progress);
        return research;
    }

    @Override
    public short getSerializationId() {
        return SerializationIdentifierConstants.LOCAL_RESEARCH_ID;
    }
}

